local t = LoadFallbackB();

if not GAMESTATE:IsCourseMode() then

-- Difficulties 
-- P1 difficulty pane
t[#t+1] = Def.ActorFrame {
	InitCommand=cmd(x,SCREEN_LEFT+140;y,SCREEN_CENTER_Y-110;);
	
	-- BG (to do, mask it)
	Def.ActorFrame {
		LoadActor("_mask pane") .. {
			InitCommand=cmd(addy,-4;zoom,0.75;blend,"BlendMode_NoEffect";zwrite,true;clearzbuffer,true;);
		};	
		LoadActor("_pane panel") .. {
			InitCommand=cmd(zoom,0.75;addy,-60;ztest,true);
			OnCommand=cmd(sleep,0.7;decelerate,0.6;addy,120;);
			OffCommand=cmd(decelerate,0.3;addy,-120;);			
		};
		-- Difficulty number
		LoadFont("_yozakura num 50px") .. { 
		InitCommand=cmd(zoom,1.5;addy,36;diffuse,color("#000000");strokecolor,color("#FFFFFF");ztest,true);
		OnCommand=function(self)
			if GAMESTATE:IsPlayerEnabled(PLAYER_1) then
				self:addy(-120):sleep(0.7):decelerate(0.6):addy(120);
			else
				self:diffusealpha(0);
			end
		end;
		OffCommand=cmd(decelerate,0.3;addy,-120;);
		CurrentStepsP1ChangedMessageCommand=cmd(queuecommand,"Set";); 
		PlayerJoinedMessageCommand=function(self,param)
			if param.Player == PLAYER_1 then
				self:queuecommand("Set"):diffusealpha(1):addy(-120):sleep(0.7):decelerate(0.6):addy(120);
			end
		end;
		ChangedLanguageDisplayMessageCommand=cmd(queuecommand,"Set");
		SetCommand=function(self)
			stepsP2 = GAMESTATE:GetCurrentSteps(PLAYER_1)
			local song = GAMESTATE:GetCurrentSong();
				if song then 
					if stepsP2 ~= nil then
						local st = stepsP2:GetStepsType();
						local diff = stepsP2:GetDifficulty();
						local courseType = GAMESTATE:IsCourseMode() and SongOrCourse:GetCourseType() or nil;
							local cd = GetCustomDifficulty(st, diff, courseType);
						self:settext(stepsP2:GetMeter())
						self:diffusebottomedge(ColorDarkTone(CustomDifficultyToColor(cd)));
					else
						self:settext("")
					end
				else
					self:settext("")
				end
			end;
		};
	};	
	
	-- Scroll top
	Def.ActorFrame {
		OnCommand=cmd(diffusealpha,0;rotationz,30;zoom,1.5;sleep,0.6;decelerate,0.3;diffusealpha,1;zoom,1;rotationz,0;);
		OffCommand=cmd(sleep,0.3;decelerate,0.3;diffusealpha,0;rotationz,30;zoom,1.5);
		LoadActor("_scroll base") .. {
			InitCommand=cmd(zoom,0.75;);
		};
		LoadActor("_diff scroll") .. {
			InitCommand=cmd(zoom,0.75;);
				OnCommand=function(self)
						stepsP1 = GAMESTATE:GetCurrentSteps(PLAYER_1)
						local song = GAMESTATE:GetCurrentSong();
						if song then 
							if stepsP1 ~= nil then
								local st = stepsP1:GetStepsType();
								local diff = stepsP1:GetDifficulty();
								local courseType = GAMESTATE:IsCourseMode() and SongOrCourse:GetCourseType() or nil;
								local cd = GetCustomDifficulty(st, diff, courseType);
								self:diffuse(CustomDifficultyToColor(cd));
							else
								self:diffuse(color("#666666"));
							end
						else
								self:diffuse(color("#666666"));
						end
				end;
				CurrentStepsP1ChangedMessageCommand=cmd(queuecommand,"Set";); 
				PlayerJoinedMessageCommand=cmd(queuecommand,"Set";);
				ChangedLanguageDisplayMessageCommand=cmd(queuecommand,"Set");
				SetCommand=function(self)
						stepsP1 = GAMESTATE:GetCurrentSteps(PLAYER_1)
						local song = GAMESTATE:GetCurrentSong();
						if song then 
							if stepsP1 ~= nil then
								local st = stepsP1:GetStepsType();
								local diff = stepsP1:GetDifficulty();
								local courseType = GAMESTATE:IsCourseMode() and SongOrCourse:GetCourseType() or nil;
								local cd = GetCustomDifficulty(st, diff, courseType);
								self:finishtweening():linear(0.2):diffuse(CustomDifficultyToColor(cd));
							else
								self:diffuse(color("#666666"));
							end
						else
								self:diffuse(color("#666666"));
						end
				end
		};
		-- Difficulty name
		LoadFont("_spaceport 24px") .. { 
				  InitCommand=cmd(zoom,0.5;diffuse,color("#FFFFFF"););
				  CurrentStepsP1ChangedMessageCommand=cmd(queuecommand,"Set";); 
				  PlayerJoinedMessageCommand=cmd(queuecommand,"Set";diffusealpha,0;smooth,0.3;diffusealpha,1;);
				  ChangedLanguageDisplayMessageCommand=cmd(queuecommand,"Set");
				  SetCommand=function(self)
					stepsP1 = GAMESTATE:GetCurrentSteps(PLAYER_1)
					local song = GAMESTATE:GetCurrentSong();
					if song then 
						if stepsP1 ~= nil then
							local st = stepsP1:GetStepsType();
							local diff = stepsP1:GetDifficulty();
							local courseType = GAMESTATE:IsCourseMode() and SongOrCourse:GetCourseType() or nil;
							local cd = GetCustomDifficulty(st, diff, courseType);
							self:settext(string.upper(THEME:GetString("CustomDifficulty",ToEnumShortString(diff))));
							self:strokecolor(ColorDarkTone(CustomDifficultyToColor(cd)));
						else
							self:settext("")
						end
					else
						self:settext("")
					end
				  end
		};
	};
	Def.ActorFrame {
	InitCommand=cmd(addy,90);
	OnCommand=cmd(diffusealpha,0;sleep,1.2;decelerate,0.2;diffusealpha,1;);
	OffCommand=cmd(decelerate,0.1;diffusealpha,0;);
		LoadActor(THEME:GetPathG("_icons", "hand")) .. {
			InitCommand=cmd(zoom,0.6;addx,-40;);
			OnCommand=cmd(diffusealpha,0.4;queuecommand,"Set");
			CurrentStepsP1ChangedMessageCommand=cmd(finishtweening;queuecommand,"Set";);
			SetCommand=function(self)
				stepsP1 = GAMESTATE:GetCurrentSteps(PLAYER_1)
				local song = GAMESTATE:GetCurrentSong();
					if song then 
						if stepsP1 ~= nil then
							local Getp1Radar = GAMESTATE:GetCurrentSteps(PLAYER_1):GetRadarValues(PLAYER_1);
							local P1Hands = Getp1Radar:GetValue('RadarCategory_Hands');
							if P1Hands ~= 0 then
								self:smooth(0.3):diffusealpha(1)
							else
								self:smooth(0.3):diffusealpha(0.4)
							end;
						else
							self:diffusealpha(0)
						end
					else
						self:diffusealpha(0)
					end
				 end
		};	
		LoadActor(THEME:GetPathG("_icons", "roll")) .. {
			InitCommand=cmd(zoom,0.6;addx,-20;);
			OnCommand=cmd(diffusealpha,0.4;queuecommand,"Set");
			CurrentStepsP1ChangedMessageCommand=cmd(finishtweening;queuecommand,"Set";);
			SetCommand=function(self)
				stepsP1 = GAMESTATE:GetCurrentSteps(PLAYER_1)
				local song = GAMESTATE:GetCurrentSong();
					if song then 
						if stepsP1 ~= nil then
							local Getp1Radar = GAMESTATE:GetCurrentSteps(PLAYER_1):GetRadarValues(PLAYER_1);
							local P1Hands = Getp1Radar:GetValue('RadarCategory_Rolls');
							if P1Hands ~= 0 then
								self:smooth(0.3):diffusealpha(1)
							else
								self:smooth(0.3):diffusealpha(0.4)
							end;
						else
							self:diffusealpha(0)
						end
					else
						self:diffusealpha(0)
					end
				 end			
		};		
		LoadActor(THEME:GetPathG("_icons", "mine")) .. {
			InitCommand=cmd(zoom,0.6;addx,0;);
			OnCommand=cmd(diffusealpha,0.4;queuecommand,"Set");
			CurrentStepsP1ChangedMessageCommand=cmd(finishtweening;queuecommand,"Set";);
			SetCommand=function(self)
				stepsP1 = GAMESTATE:GetCurrentSteps(PLAYER_1)
				local song = GAMESTATE:GetCurrentSong();
					if song then 
						if stepsP1 ~= nil then
							local Getp1Radar = GAMESTATE:GetCurrentSteps(PLAYER_1):GetRadarValues(PLAYER_1);
							local P1Hands = Getp1Radar:GetValue('RadarCategory_Mines');
							if P1Hands ~= 0 then
								self:smooth(0.3):diffusealpha(1)
							else
								self:smooth(0.3):diffusealpha(0.4)
							end;
						else
							self:diffusealpha(0)
						end
					else
						self:diffusealpha(0)
					end
				 end			
		};		
		LoadActor(THEME:GetPathG("_icons", "lift")) .. {
			InitCommand=cmd(zoom,0.6;addx,20;);
			OnCommand=cmd(diffusealpha,0.4;queuecommand,"Set");
			CurrentStepsP1ChangedMessageCommand=cmd(finishtweening;queuecommand,"Set";);
			SetCommand=function(self)
				stepsP1 = GAMESTATE:GetCurrentSteps(PLAYER_1)
				local song = GAMESTATE:GetCurrentSong();
					if song then 
						if stepsP1 ~= nil then
							local Getp1Radar = GAMESTATE:GetCurrentSteps(PLAYER_1):GetRadarValues(PLAYER_1);
							local P1Hands = Getp1Radar:GetValue('RadarCategory_Lifts');
							if P1Hands ~= 0 then
								self:smooth(0.3):diffusealpha(1)
							else
								self:smooth(0.3):diffusealpha(0.4)
							end;
						else
							self:diffusealpha(0)
						end
					else
						self:diffusealpha(0)
					end
				 end			
		};			
		LoadActor(THEME:GetPathG("_icons", "fake")) .. {
			InitCommand=cmd(zoom,0.6;addx,40;);
			OnCommand=cmd(diffusealpha,0.4;queuecommand,"Set");
			CurrentStepsP1ChangedMessageCommand=cmd(finishtweening;queuecommand,"Set";);
			SetCommand=function(self)
				stepsP1 = GAMESTATE:GetCurrentSteps(PLAYER_1)
				local song = GAMESTATE:GetCurrentSong();
					if song then 
						if stepsP1 ~= nil then
							local Getp1Radar = GAMESTATE:GetCurrentSteps(PLAYER_1):GetRadarValues(PLAYER_1);
							local P1Hands = Getp1Radar:GetValue('RadarCategory_Fakes');
							if P1Hands ~= 0 then
								self:smooth(0.3):diffusealpha(1)
							else
								self:smooth(0.3):diffusealpha(0.4)
							end;
						else
							self:diffusealpha(0)
						end
					else
						self:diffusealpha(0)
					end
				 end			
		};		
	};
};

t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(x,SCREEN_LEFT+140;y,SCREEN_CENTER_Y+66;);
		LoadActor("_score panel") .. {
		OnCommand=cmd(zoom,0.8;diffusealpha,0;sleep,0.8;decelerate,0.3;zoom,1;diffusealpha,1);		
		OffCommand=cmd(sleep,0.3;decelerate,0.2;zoom,0.8;diffusealpha,0);		
		};
	};

-- Player 2
t[#t+1] = Def.ActorFrame {
	InitCommand=cmd(x,SCREEN_RIGHT-140;y,SCREEN_CENTER_Y-110;);
	
	-- BG and pane masking
	Def.ActorFrame {
		LoadActor("_mask pane") .. {
			InitCommand=cmd(addy,-4;zoom,0.75;blend,"BlendMode_NoEffect";zwrite,true;clearzbuffer,true;);
		};	
		LoadActor("_pane panel") .. {
			InitCommand=cmd(zoom,0.75;addy,-60;ztest,true);
			OnCommand=cmd(sleep,0.7;decelerate,0.6;addy,120;);
			OffCommand=cmd(decelerate,0.3;addy,-120;);			
		};
		-- Difficulty number
		LoadFont("_yozakura num 50px") .. { 
		InitCommand=cmd(zoom,1.5;addy,36;diffuse,color("#000000");strokecolor,color("#FFFFFF");ztest,true);
		OnCommand=function(self)
			if GAMESTATE:IsPlayerEnabled(PLAYER_2) then
				self:addy(-120):sleep(0.7):decelerate(0.6):addy(120);
			else
				self:diffusealpha(0);
			end
		end;
		OffCommand=cmd(decelerate,0.3;addy,-120;);
		CurrentStepsP2ChangedMessageCommand=cmd(queuecommand,"Set";); 
		PlayerJoinedMessageCommand=function(self,param)
			if param.Player == PLAYER_2 then
				self:queuecommand("Set"):diffusealpha(1):addy(-120):sleep(0.7):decelerate(0.6):addy(120);
			end
		end;
		ChangedLanguageDisplayMessageCommand=cmd(queuecommand,"Set");
		SetCommand=function(self)
			stepsP2 = GAMESTATE:GetCurrentSteps(PLAYER_2)
			local song = GAMESTATE:GetCurrentSong();
				if song then 
					if stepsP2 ~= nil then
						local st = stepsP2:GetStepsType();
						local diff = stepsP2:GetDifficulty();
						local courseType = GAMESTATE:IsCourseMode() and SongOrCourse:GetCourseType() or nil;
							local cd = GetCustomDifficulty(st, diff, courseType);
						self:settext(stepsP2:GetMeter())
						self:diffusebottomedge(ColorDarkTone(CustomDifficultyToColor(cd)));
					else
						self:settext("")
					end
				else
					self:settext("")
				end
			end;
		};
	};	
	
	-- Scroll top
	Def.ActorFrame {
		OnCommand=cmd(diffusealpha,0;rotationz,-30;zoom,1.5;sleep,0.6;decelerate,0.3;diffusealpha,1;zoom,1;rotationz,0;);
		OffCommand=cmd(sleep,0.3;decelerate,0.3;diffusealpha,0;rotationz,-30;zoom,1.5);
		LoadActor("_scroll base") .. {
			InitCommand=cmd(zoom,0.75;);
		};
		LoadActor("_diff scroll") .. {
			InitCommand=cmd(zoom,0.75;);
				OnCommand=function(self)
						stepsP2 = GAMESTATE:GetCurrentSteps(PLAYER_2)
						local song = GAMESTATE:GetCurrentSong();
						if song then 
							if stepsP2 ~= nil then
								local st = stepsP2:GetStepsType();
								local diff = stepsP2:GetDifficulty();
								local courseType = GAMESTATE:IsCourseMode() and SongOrCourse:GetCourseType() or nil;
								local cd = GetCustomDifficulty(st, diff, courseType);
								self:diffuse(CustomDifficultyToColor(cd));
							else
								self:diffuse(color("#666666"));
							end
						else
								self:diffuse(color("#666666"));
						end
				end;
				CurrentStepsP2ChangedMessageCommand=cmd(queuecommand,"Set";); 
				PlayerJoinedMessageCommand=cmd(queuecommand,"Set";);
				ChangedLanguageDisplayMessageCommand=cmd(queuecommand,"Set");
				SetCommand=function(self)
						stepsP2 = GAMESTATE:GetCurrentSteps(PLAYER_2)
						local song = GAMESTATE:GetCurrentSong();
						if song then 
							if stepsP2 ~= nil then
								local st = stepsP2:GetStepsType();
								local diff = stepsP2:GetDifficulty();
								local courseType = GAMESTATE:IsCourseMode() and SongOrCourse:GetCourseType() or nil;
								local cd = GetCustomDifficulty(st, diff, courseType);
								self:finishtweening():linear(0.2):diffuse(CustomDifficultyToColor(cd));
							else
								self:diffuse(color("#666666"));
							end
						else
								self:diffuse(color("#666666"));
						end
				end
		};
		-- Difficulty name
		LoadFont("_spaceport 24px") .. { 
				  InitCommand=cmd(zoom,0.5;diffuse,color("#FFFFFF"););
				  CurrentStepsP2ChangedMessageCommand=cmd(queuecommand,"Set";); 
				  PlayerJoinedMessageCommand=cmd(queuecommand,"Set";diffusealpha,0;smooth,0.3;diffusealpha,1;);
				  ChangedLanguageDisplayMessageCommand=cmd(queuecommand,"Set");
				  SetCommand=function(self)
					stepsP2 = GAMESTATE:GetCurrentSteps(PLAYER_2)
					local song = GAMESTATE:GetCurrentSong();
					if song then 
						if stepsP2 ~= nil then
							local st = stepsP2:GetStepsType();
							local diff = stepsP2:GetDifficulty();
							local courseType = GAMESTATE:IsCourseMode() and SongOrCourse:GetCourseType() or nil;
							local cd = GetCustomDifficulty(st, diff, courseType);
							self:settext(string.upper(THEME:GetString("CustomDifficulty",ToEnumShortString(diff))));
							self:strokecolor(ColorDarkTone(CustomDifficultyToColor(cd)));
						else
							self:settext("")
						end
					else
						self:settext("")
					end
				  end
		};
	};
	Def.ActorFrame {
	InitCommand=cmd(addy,90);
	OnCommand=cmd(diffusealpha,0;sleep,1.2;decelerate,0.2;diffusealpha,1;);
	OffCommand=cmd(decelerate,0.1;diffusealpha,0;);
		LoadActor(THEME:GetPathG("_icons", "hand")) .. {
			InitCommand=cmd(zoom,0.6;addx,-40;);
			OnCommand=cmd(diffusealpha,0.4;queuecommand,"Set");
			CurrentStepsP2ChangedMessageCommand=cmd(finishtweening;queuecommand,"Set";);
			SetCommand=function(self)
				stepsP2 = GAMESTATE:GetCurrentSteps(PLAYER_2)
				local song = GAMESTATE:GetCurrentSong();
					if song then 
						if stepsP2 ~= nil then
							local GetP2Radar = GAMESTATE:GetCurrentSteps(PLAYER_2):GetRadarValues(PLAYER_2);
							local P2Hands = GetP2Radar:GetValue('RadarCategory_Hands');
							if P2Hands ~= 0 then
								self:smooth(0.3):diffusealpha(1)
							else
								self:smooth(0.3):diffusealpha(0.4)
							end;
						else
							self:diffusealpha(0)
						end
					else
						self:diffusealpha(0)
					end
				 end
		};	
		LoadActor(THEME:GetPathG("_icons", "roll")) .. {
			InitCommand=cmd(zoom,0.6;addx,-20;);
			OnCommand=cmd(diffusealpha,0.4;queuecommand,"Set");
			CurrentStepsP2ChangedMessageCommand=cmd(finishtweening;queuecommand,"Set";);
			SetCommand=function(self)
				stepsP2 = GAMESTATE:GetCurrentSteps(PLAYER_2)
				local song = GAMESTATE:GetCurrentSong();
					if song then 
						if stepsP2 ~= nil then
							local GetP2Radar = GAMESTATE:GetCurrentSteps(PLAYER_2):GetRadarValues(PLAYER_2);
							local P2Hands = GetP2Radar:GetValue('RadarCategory_Rolls');
							if P2Hands ~= 0 then
								self:smooth(0.3):diffusealpha(1)
							else
								self:smooth(0.3):diffusealpha(0.4)
							end;
						else
							self:diffusealpha(0)
						end
					else
						self:diffusealpha(0)
					end
				 end			
		};		
		LoadActor(THEME:GetPathG("_icons", "mine")) .. {
			InitCommand=cmd(zoom,0.6;addx,0;);
			OnCommand=cmd(diffusealpha,0.4;queuecommand,"Set");
			CurrentStepsP2ChangedMessageCommand=cmd(finishtweening;queuecommand,"Set";);
			SetCommand=function(self)
				stepsP2 = GAMESTATE:GetCurrentSteps(PLAYER_2)
				local song = GAMESTATE:GetCurrentSong();
					if song then 
						if stepsP2 ~= nil then
							local GetP2Radar = GAMESTATE:GetCurrentSteps(PLAYER_2):GetRadarValues(PLAYER_2);
							local P2Hands = GetP2Radar:GetValue('RadarCategory_Mines');
							if P2Hands ~= 0 then
								self:smooth(0.3):diffusealpha(1)
							else
								self:smooth(0.3):diffusealpha(0.4)
							end;
						else
							self:diffusealpha(0)
						end
					else
						self:diffusealpha(0)
					end
				 end			
		};		
		LoadActor(THEME:GetPathG("_icons", "lift")) .. {
			InitCommand=cmd(zoom,0.6;addx,20;);
			OnCommand=cmd(diffusealpha,0.4;queuecommand,"Set");
			CurrentStepsP2ChangedMessageCommand=cmd(finishtweening;queuecommand,"Set";);
			SetCommand=function(self)
				stepsP2 = GAMESTATE:GetCurrentSteps(PLAYER_2)
				local song = GAMESTATE:GetCurrentSong();
					if song then 
						if stepsP2 ~= nil then
							local GetP2Radar = GAMESTATE:GetCurrentSteps(PLAYER_2):GetRadarValues(PLAYER_2);
							local P2Hands = GetP2Radar:GetValue('RadarCategory_Lifts');
							if P2Hands ~= 0 then
								self:smooth(0.3):diffusealpha(1)
							else
								self:smooth(0.3):diffusealpha(0.4)
							end;
						else
							self:diffusealpha(0)
						end
					else
						self:diffusealpha(0)
					end
				 end			
		};			
		LoadActor(THEME:GetPathG("_icons", "fake")) .. {
			InitCommand=cmd(zoom,0.6;addx,40;);
			OnCommand=cmd(diffusealpha,0.4;queuecommand,"Set");
			CurrentStepsP2ChangedMessageCommand=cmd(finishtweening;queuecommand,"Set";);
			SetCommand=function(self)
				stepsP2 = GAMESTATE:GetCurrentSteps(PLAYER_2)
				local song = GAMESTATE:GetCurrentSong();
					if song then 
						if stepsP2 ~= nil then
							local GetP2Radar = GAMESTATE:GetCurrentSteps(PLAYER_2):GetRadarValues(PLAYER_2);
							local P2Hands = GetP2Radar:GetValue('RadarCategory_Fakes');
							if P2Hands ~= 0 then
								self:smooth(0.3):diffusealpha(1)
							else
								self:smooth(0.3):diffusealpha(0.4)
							end;
						else
							self:diffusealpha(0)
						end
					else
						self:diffusealpha(0)
					end
				 end			
		};		
	};
};

t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(x,SCREEN_RIGHT-140;y,SCREEN_CENTER_Y+66;);
		LoadActor("_score panel") .. {
		OnCommand=cmd(zoom,0.8;diffusealpha,0;sleep,0.8;decelerate,0.3;zoom,1;diffusealpha,1);		
		OffCommand=cmd(sleep,0.3;decelerate,0.2;zoom,0.8;diffusealpha,0);		
		};
	};

-- Highlighted song data
t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(x,SCREEN_CENTER_X-180;y,SCREEN_CENTER_Y-110;);
		OnCommand=cmd(diffusealpha,0;decelerate,0.3;diffusealpha,1;);
		LoadFont("Common normal") .. {
				  InitCommand=cmd(maxwidth,300;horizalign,left;zoom,0.5;strokecolor,color("#212324");visible,not GAMESTATE:IsCourseMode(););
				  OnCommand=function(self)
						self:diffuse(color("#FFFFFF"));
					end;
				  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
				  CurrentSongChangedMessageCommand=cmd(finishtweening;queuecommand,"Set");
				  CurrentCourseChangedMessageCommand=cmd(finishtweening;queuecommand,"Set");
				  ChangedLanguageDisplayMessageCommand=cmd(finishtweening;queuecommand,"Set");
				  SetCommand=function(self)
					   local song = GAMESTATE:GetCurrentSong();
					   if song then
							self:settext(song:GetGenre()); 
							self:playcommand("Refresh");
							(cmd(stoptweening;addx,-6;smooth,0.2;addx,6;diffusealpha,1))(self)
						else
							self:settext("");
							self:playcommand("Refresh");
					   end
				  end;
		};
		-- Title
		LoadFont("_teko semibold 36px") .. {
				  InitCommand=cmd(addy,27;maxwidth,270;diffuse,color("#FFFEE3");strokecolor,color("#212324");diffusebottomedge,color("#FFE880");horizalign,left;visible,not GAMESTATE:IsCourseMode(););
				  OffCommand=cmd(decelerate,0.3;diffusealpha,0;);
				  CurrentSongChangedMessageCommand=cmd(finishtweening;queuecommand,"Set");
				  CurrentCourseChangedMessageCommand=cmd(finishtweening;queuecommand,"Set");
				  ChangedLanguageDisplayMessageCommand=cmd(finishtweening;queuecommand,"Set");
				  SetCommand=function(self)
					   local song = GAMESTATE:GetCurrentSong();
					   if song then
							self:settext(song:GetDisplayFullTitle());
							self:playcommand("Refresh");
							(cmd(stoptweening;addx,-6;smooth,0.2;addx,6;diffusealpha,1))(self)
						else
							self:settext("");
							self:playcommand("Refresh");
					   end
				  end;
		};
		-- Show group name instead of song title if group highlighted
		LoadFont("_teko semibold 36px") .. {
				  InitCommand=cmd(addy,33;maxwidth,270;diffuse,color("#D8ECF2");strokecolor,color("#212324");diffusebottomedge,color("#9EDBF0");horizalign,left;visible,not GAMESTATE:IsCourseMode(););
				  OffCommand=cmd(decelerate,0.3;diffusealpha,0;);
				  CurrentSongChangedMessageCommand=cmd(finishtweening;queuecommand,"Set");
				  CurrentCourseChangedMessageCommand=cmd(finishtweening;queuecommand,"Set");
				  ChangedLanguageDisplayMessageCommand=cmd(finishtweening;queuecommand,"Set");
				  SetCommand=function(self)
					   local song = GAMESTATE:GetCurrentSong();
					   if song then
					   		self:settext("");
							self:playcommand("Refresh");
						else
							self:settext(SCREENMAN:GetTopScreen():GetMusicWheel():GetSelectedSection()); 
							self:playcommand("Refresh");
							(cmd(stoptweening;addx,-6;smooth,0.2;addx,6;diffusealpha,1))(self)
					   end
				  end;
		};		
		-- Artist
		LoadFont("Common normal") .. {
				  InitCommand=cmd(addy,50;zoom,0.5;maxwidth,370;horizalign,left;strokecolor,color("#212324");visible,not GAMESTATE:IsCourseMode(););				  
				  OnCommand=function(self)
						self:diffuse(color("#FFFFFF"));
					end;
				  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
				  CurrentSongChangedMessageCommand=cmd(finishtweening;queuecommand,"Set");
				  CurrentCourseChangedMessageCommand=cmd(finishtweening;queuecommand,"Set");
				  ChangedLanguageDisplayMessageCommand=cmd(finishtweening;queuecommand,"Set");
				  SetCommand=function(self)
					   local song = GAMESTATE:GetCurrentSong();
					   if song then
							self:settext(song:GetDisplayArtist());
							self:playcommand("Refresh");
							(cmd(stoptweening;addx,-6;smooth,0.2;addx,6;diffusealpha,1))(self)
						else
							self:settext("");
							self:playcommand("Refresh");
					   end
				  end;
		};

};

t[#t+1] = StandardDecorationFromFileOptional("DifficultyList","DifficultyList");
t[#t+1] = StandardDecorationFromFileOptional("GrooveRadar","GrooveRadar");

t[#t+1] = StandardDecorationFromFileOptional("BPMDisplay","BPMDisplay");
t[#t+1] = LoadFont("_squares bold 24px") .. {
            InitCommand=cmd(x,SCREEN_CENTER_X-50;y,SCREEN_CENTER_Y-4;diffuse,color("#FFFFFF");strokecolor,color("#000000"););
            OnCommand=cmd(queuecommand,"Set";diffusealpha,0;decelerate,0.35;diffusealpha,1;);
            OffCommand=cmd(decelerate,0.2;diffusealpha,0;);
            ChangedLanguageDisplayMessageCommand=cmd(queuecommand,"Set");
            SetCommand=function(self)
                self:settext("BPM");
                self:queuecommand("Refresh");
            end;
    };

t[#t+1] = Def.ActorFrame {
    InitCommand=cmd(x,SCREEN_CENTER_X+150;y,SCREEN_CENTER_Y-170;visible,not GAMESTATE:IsCourseMode(););
    OnCommand=cmd(diffusealpha,0;zoomx,0.7;sleep,0.3;decelerate,0.3;diffusealpha,1;zoomx,1;);
	OffCommand=cmd(decelerate,0.3;diffusealpha,0;);
	LoadActor(THEME:GetPathG("", "_stageFrame"))  .. {
	    InitCommand=cmd(diffusealpha,1;zoom,1.0);
	};

    LoadFont("_teko light 24px") .. {
            InitCommand=cmd(zoom,0.75;diffuse,color("#FFFFFF");diffusealpha,0.6;horizalign,left;addx,-80;);
            OnCommand=cmd(queuecommand,"Set");
            ChangedLanguageDisplayMessageCommand=cmd(queuecommand,"Set");
            SetCommand=function(self)
                self:settext("SORT:");
                self:queuecommand("Refresh");
            end;
    };

    LoadFont("_teko light 24px") .. {
          InitCommand=cmd(zoom,0.75;maxwidth,SCREEN_WIDTH;addx,-48;diffuse,color("#FFFFFF");uppercase,true;horizalign,left;);
          OnCommand=cmd(queuecommand,"Set");
          SortOrderChangedMessageCommand=cmd(queuecommand,"Set");
          ChangedLanguageDisplayMessageCommand=cmd(queuecommand,"Set");
          SetCommand=function(self)
               local sortorder = GAMESTATE:GetSortOrder();
               if sortorder then
					self:finishtweening();
					self:smooth(0.4);
					self:diffusealpha(0);
                    self:settext(SortOrderToLocalizedString(sortorder));
                    self:queuecommand("Refresh"):stoptweening():diffusealpha(0):smooth(0.3):diffusealpha(1)
				else
					self:settext("");
					self:queuecommand("Refresh");
               end
          end;
    };
	
	    LoadFont("_teko light 24px") .. {
          InitCommand=cmd(zoom,0.75;maxwidth,SCREEN_WIDTH;addx,80;diffuse,color("#FFFFFF");uppercase,true;horizalign,right;);
          OnCommand=cmd(queuecommand,"Set");
          ChangedLanguageDisplayMessageCommand=cmd(queuecommand,"Set");
          		SetCommand=function(self)
			local curScreen = Var "LoadingScreen";
			local curStageIndex = GAMESTATE:GetCurrentStageIndex() + 1;
			local playMode = GAMESTATE:GetPlayMode();
			local curStage = GAMESTATE:GetCurrentStage();
			if GAMESTATE:IsCourseMode() then
				local stats = STATSMAN:GetCurStageStats()
				if not stats then
					return
				end
				local mpStats = stats:GetPlayerStageStats( GAMESTATE:GetMasterPlayerNumber() )
				local songsPlayed = mpStats:GetSongsPassed() + 1
				self:settextf("%i / %i", songsPlayed, GAMESTATE:GetCurrentCourse():GetEstimatedNumStages());
			else
				if GAMESTATE:IsEventMode() then
					self:settextf("FREE");
				else
					self:settextf("%s", ToEnumShortString(curStage));
				end
			end;
			self:diffuse(StageToColor(curStage));
			end;
		};
};	
	
else

t[#t+1] = LoadFont("_teko semibold 36px") .. {
		  InitCommand=cmd(x,SCREEN_CENTER_X-320;y,SCREEN_CENTER_Y-80;maxwidth,270;diffuse,color("#DCE5E8");strokecolor,color("#272E30");diffusebottomedge,color("#BFC7C9");horizalign,left;);
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;);
		  OnCommand=function(self)
			self:queuecommand("Set")
			end;
		  CurrentSongChangedMessageCommand=cmd(queuecommand,"Set"); 
          CurrentCourseChangedMessageCommand=cmd(queuecommand,"Set"); 
          ChangedLanguageDisplayMessageCommand=cmd(queuecommand,"Set"); 
          SetCommand=function(self) 
               local course = GAMESTATE:GetCurrentCourse(); 
               if course then
                    self:settext(course:GetDisplayFullTitle()); 
                    self:queuecommand("Refresh");
					(cmd(stoptweening;addx,-6;smooth,0.2;addx,6;diffusealpha,1))(self)
				else
					self:settext("");
					self:queuecommand("Refresh"); 	
               end 
          end; 
	};
	
t[#t+1] = LoadFont("Common normal") .. {
				  InitCommand=cmd(x,SCREEN_CENTER_X-320;y,SCREEN_CENTER_Y-80+20;horizalign,left;strokecolor,color("#212324");zoom,0.5);
				  OnCommand=function(self)
						self:diffuse(color("#FFFFFF"));
					end;
				  OffCommand=cmd(decelerate,0.3;diffusealpha,0;);
				  CurrentSongChangedMessageCommand=cmd(finishtweening;queuecommand,"Set");
				  CurrentCourseChangedMessageCommand=cmd(finishtweening;queuecommand,"Set");
				  ChangedLanguageDisplayMessageCommand=cmd(finishtweening;queuecommand,"Set");
				  SetCommand=function(self)
					local course = GAMESTATE:GetCurrentCourse(); 
					   if course then
							self:settext(string.upper(CourseTypeToLocalizedString(course:GetCourseType()) .. ' Course - ' .. course:GetEstimatedNumStages() .. " songs")); 
							self:playcommand("Refresh");
						else
							self:settext("");
							self:playcommand("Refresh");
					   end
				  end;
		};	

t[#t+1] = StandardDecorationFromFileOptional("CourseContentsList","CourseContentsList");	
	
end;

return t